<div>
    <div class="row align-items-center justify-content-between mb-4">
        <div class="col">
            <h5 class="fw-500 text-white"><?php echo e($lang->data['add_order'] ?? 'Add Order'); ?></h5>
        </div>
        <div class="col-auto">
            <a href="<?php echo e(route('admin.view_orders')); ?>" class="btn btn-icon btn-3 btn-white text-primary mb-0">
                <i class="fa fa-arrow-left me-2"></i> <?php echo e($lang->data['back'] ?? 'Back'); ?>

            </a>
        </div>
    </div>
    <div class="row match-height">
        <div class="col-lg-7 col-12">
            <div class="card mb-4">
                <div class="card-header p-4">
                    <div class="row">
                        <div class="col-md-12">
                            <input type="text" class="form-control"
                                placeholder="<?php echo e($lang->data['search_here'] ?? 'Search Here'); ?>"
                                wire:model="search_query">
                        </div>
                    </div>
                </div>
                <div class="pos-card-wrapper-scroll-y my-custom-scrollbar-pos-card  mb-3">
                    <div class="row align-items-center g-3 px-4 ">
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-3 col-6 text-center">
                                <div class="border-dashed border-1 border-secondary border-radius-md py-1">
                                    <a type="button" data-bs-toggle="modal" data-bs-target="#servicetype"
                                        wire:click="selectService(<?php echo e($item->id); ?>)">
                                        <div class="avatar avatar-xl mb-3">
                                            <img src="<?php echo e(asset('assets/img/service-icons/' . $item->icon)); ?>"
                                                class="rounded p-2">
                                        </div>
                                        <p class="text-xs font-weight-bold"><?php echo e($item->service_name); ?></p>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-5 col-12">
            <div class="card mb-4">
                <div class="card-header p-4">
                    <div class="row">
                        <div class="col-md-9 mb-3">
                            <input type="text" wire:model="customer_query" class="form-control"
                                placeholder="<?php if(!$selected_customer): ?> <?php echo e($lang->data['select_a_customer'] ?? 'Select A Customer'); ?> <?php else: ?> <?php echo e($selected_customer->name); ?> <?php endif; ?>">
                            <?php if($customers && count($customers) > 0): ?>
                                <ul class="list-group customhover">
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="list-group-item customhover2"
                                            wire:click="selectCustomer(<?php echo e($row->id); ?>)"><?php echo e($row->name); ?> - <?php echo e($row->phone); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-3 mb-3">
                            <button type="button" class="btn btn-primary mb-0" data-bs-toggle="modal"
                                data-bs-target="#addcustomer">
                                <i class="fa fa-plus me-2"></i> <?php echo e($lang->data['add'] ?? 'Add'); ?>

                            </button>
                        </div>
                        <div class="col-md-6">
                            <input type="text" required class="form-control" readonly value="<?php echo e($order_id); ?>">
                        </div>
                        <div class="col-md-6">
                            <input type="date" class="form-control" wire:model="date">
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table align-items-center mb-3">
                            <thead class="bg-light">
                                <tr>
                                    <th class="text-uppercase text-secondary text-xs opacity-7 ps-5">
                                        <?php echo e($lang->data['service'] ?? 'Service'); ?></th>
                                        <th class="text-uppercase text-secondary text-xs opacity-7 ps-5">
                                            <?php echo e($lang->data['color'] ?? 'Color'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7">
                                        <?php echo e($lang->data['rate'] ?? 'Rate'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7">
                                        <?php echo e($lang->data['qty'] ?? 'QTY'); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="order-list-wrapper-scroll-y my-custom-scrollbar-order-list">
                        <div class="row align-items-center g-3 px-4 ">
                            <?php $__currentLoopData = $selservices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-12 col-12">
                                    <div class="row ms-2 align-items-center">
                                        <div class="col-4">
                                            <h6 class="text-xs h6 mb-0">
                                                <?php
                                                    $serviceinline = null;
                                                    if (isset($item['service'])) {
                                                        $serviceinline = \App\Models\Service::where('id', $item['service'])->first();
                                                    }
                                                    if (isset($item['service_type'])) {
                                                        $servicetypeinline = \App\Models\ServiceType::where('id', $item['service_type'])->first();
                                                    }
                                                ?>
                                                <?php echo e($serviceinline->service_name); ?>

                                            </h6>
                                            <span
                                                class="text-xxs fw-600 text-primary">[<?php echo e($servicetypeinline->service_type_name); ?>]</span>
                                        </div>
                                        <div class="col-2">
                                                <input class="form-control" type="color"  pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$"  wire:model="colors.<?php echo e($key); ?>" wire:change="changeColor(<?php echo e($key); ?>)">
                                        </div>
                                        <div class="col-3">
                                            <input type="number" class="form-control form-control-sm text-center"
                                                wire:model="prices.<?php echo e($key); ?>" value="10000">
                                        </div>
                                        <div class="col-3">
                                            <div class="input-group align-items-center">
                                                <div class="badge bg-secondary text-xxs text-center p-66" type="button"
                                                    wire:click="decrease(<?php echo e($key); ?>)"><i
                                                        class="fa fa-minus"></i></div>
                                                <input type="number" class="form-control form-control-sm text-center"
                                                    wire:model="quantity.<?php echo e($key); ?>">
                                                <div class="badge bg-primary text-xxs text-center p-66" type="button"
                                                    wire:click="increase(<?php echo e($key); ?>)"><i
                                                        class="fa fa-plus"></i></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row align-items-center px-4 mb-3">
                    <div class="col">
                        <p class="text-sm mb-0 fw-500"><?php echo e($lang->data['gross_total'] ?? 'Gross Total'); ?></p>
                        <p class="text-sm text-success fw-600 mb-0"><?php echo e(getCurrency()); ?>

                            <?php echo e(number_format($sub_total, 2)); ?></p>
                    </div>
                    <div class="col-auto">
                        <button type="button" wire:click="clearAll"
                            class="btn btn-danger me-2 mb-0"><?php echo e($lang->data['clear_all'] ?? 'Clear All'); ?></button>
                        <button type="submit" class="btn btn-primary mb-0" data-bs-toggle="modal"
                            data-bs-target="#payment"><?php echo e($lang->data['save_continue'] ?? 'Save and Continue'); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade " id="servicetype" tabindex="-1" role="dialog" aria-labelledby="servicetype"
        aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title fw-600" id="servicetype">
                        <?php echo e($lang->data['select_service_type'] ?? 'Select Service Type'); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form>
                    <div class="modal-body">
                        <div class="row g-2 align-items-center"
                            x-data="{servtypes : <?php if ((object) ('service_types') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($_instance->id); ?>').entangle('<?php echo e('service_types'->value()); ?>')<?php echo e('service_types'->hasModifier('defer') ? '.defer' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($_instance->id); ?>').entangle('<?php echo e('service_types'); ?>')<?php endif; ?>,seltype : <?php if ((object) ('selected_type') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($_instance->id); ?>').entangle('<?php echo e('selected_type'->value()); ?>')<?php echo e('selected_type'->hasModifier('defer') ? '.defer' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($_instance->id); ?>').entangle('<?php echo e('selected_type'); ?>')<?php endif; ?>}">
                            <template x-for="item in servtypes">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" :id="'test'+item.id" name="test"
                                        :value="item.id" x-model="seltype">
                                    <label class="form-check-label" :for="'test'+item.id"></label>
                                    <span x-text="item.service_type_name"> </span>
                                </div>
                            </template>
                            <?php $__errorArgs = ['service_error'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e($lang->data['cancel'] ?? 'Cancel'); ?></button>
                        <button type="submit" class="btn btn-primary"
                            wire:click.prevent="addItem"><?php echo e($lang->data['add'] ?? 'Add'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade " id="addcustomer" tabindex="-1" role="dialog" aria-labelledby="addcustomer"
        aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title fw-600" id="addcustomer"><?php echo e($lang->data['add_customer'] ?? 'Add Customer'); ?>

                    </h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form>
                    <div class="modal-body">
                        <div class="row g-2 align-items-center">
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['customer_name'] ?? 'Customer Name'); ?>

                                    <span class="text-danger">*</span></label>
                                <input type="text" required class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_customer_name'] ?? 'Enter Customer Name'); ?>"
                                    wire:model="customer_name">
                                <?php $__errorArgs = ['customer_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['phone_number'] ?? 'Phone Number'); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="text" required class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_phone_number'] ?? 'Enter Phone Number'); ?>"
                                    wire:model="customer_phone">
                                <?php $__errorArgs = ['customer_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['email'] ?? 'Email'); ?></label>
                                <input type="text" class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_email'] ?? 'Enter Email'); ?>" wire:model="email">
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['tax_number'] ?? 'Tax Number'); ?></label>
                                <input type="text" class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_tax_number'] ?? 'Enter Tax Number'); ?>"
                                    wire:model="tax_no">
                            </div>
                            <div class="col-md-12 mb-3">
                                <label class="form-label"><?php echo e($lang->data['address'] ?? 'Address'); ?></label>
                                <textarea type="text" class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_address'] ?? 'Enter Address'); ?>"
                                    wire:model="address"></textarea>
                            </div>
                            <div class="col-md-12 mb-1">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="employee" checked
                                        wire:model="is_active">
                                    <label class="form-check-label"
                                        for="employee"><?php echo e($lang->data['is_active'] ?? 'Is Active'); ?> ?</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e($lang->data['cancel'] ?? 'Cancel'); ?></button>
                        <button type="button" class="btn btn-primary"
                            wire:click.prevent="createCustomer()"><?php echo e($lang->data['save'] ?? 'Save'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade " id="payment" tabindex="-1" role="dialog" aria-labelledby="payment" aria-hidden="true"
        wire:ignore.self>
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title fw-600" id="payment">
                        <?php echo e($lang->data['payment_details'] ?? 'Payment Details'); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form>
                    <div class="modal-body">
                        <div class="row g-2 align-items-center">
                            <?php $__currentLoopData = $addons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="addon"
                                            id="addon<?php echo e($row->id); ?>"
                                            wire:model="selected_addons.<?php echo e($row->id); ?>">
                                        <label class="custom-control-label"
                                            for="addon<?php echo e($row->id); ?>"><?php echo e($row->addon_name); ?></label>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class=" col-12">
                                <?php if($addons): ?>
                                <?php if(count($addons) > 0): ?>
                                <hr>
                                <?php endif; ?>
                                <?php endif; ?>
                                <div class="row align-items-center">
                                    <div class="col-md-6 mb-1">
                                        <label
                                            class="form-label"><?php echo e($lang->data['delivery_date'] ?? 'Delivery Date'); ?></label>
                                        <input type="date" class="form-control" wire:model="delivery_date">
                                    </div>
                                    <div class="col-md-6 mb-1">
                                        <label
                                            class="form-label"><?php echo e($lang->data['discount'] ?? 'Discount'); ?></label>
                                        <input type="number" class="form-control"
                                            placeholder="<?php echo e($lang->data['enter_amount'] ?? 'Enter Amount'); ?>"
                                            wire:model="discount">
                                    </div>
                                </div>
                                <hr>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500"><?php echo e($lang->data['sub_total'] ?? 'Sub Total'); ?>:
                                    </div>
                                    <div class="col-auto  text-sm fw-500"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($sub_total, 2)); ?></div>
                                </div>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500"><?php echo e($lang->data['addon'] ?? 'Addon'); ?>:</div>
                                    <div class="col-auto text-sm fw-500"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($addon_total, 2)); ?></div>
                                </div>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500"><?php echo e($lang->data['discount'] ?? 'Discount'); ?>:</div>
                                    <div class="col-auto  text-sm fw-500"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($discount, 2)); ?></div>
                                </div>
                                <div class="row mb-50 align-items-center">
                                    <div class="col text-sm fw-500"><?php echo e($lang->data['tax'] ?? 'Tax'); ?>

                                        (<?php echo e(getTaxPercentage()); ?>%):</div>
                                    <div class="col-auto text-sm fw-500"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($tax, 2)); ?></div>
                                </div>
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col text-sm fw-600"><?php echo e($lang->data['gross_total'] ?? 'Gross Total'); ?>:
                                    </div>
                                    <div class="col-auto text-sm fw-600"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($total, 2)); ?></div>
                                </div>
                                <hr>
                                <div class="row ">
                                    <div class="col-md-4 mb-1 pr-0">
                                        <label
                                            class="form-label"><?php echo e($lang->data['paid_amount'] ?? 'Paid Amount'); ?></label>
                                        <input type="number" class="form-control"
                                            placeholder="<?php echo e($lang->data['enter_amount'] ?? 'Enter Amount'); ?>"
                                            wire:model="paid_amount">
                                    </div>
                                    <div class="col-md-1 m-0 p-0">
                                        <label for="" class="form-label"> &nbsp; </label>
                                        <button class="btn btn-icon btn-2 btn-primary " type="button" wire:click="magicFill">
                                            <span class="btn-inner--icon px-0 mx-0"><i class="fa fa-magic m-0 p-0"></i></span>
                                        </button>
                                    </div>
                                    
                                    <div class="col-6 mx-2 mb-1 " >
                                        <label
                                            class="form-label"><?php echo e($lang->data['payment_type'] ?? 'Payment Type'); ?></label>
                                        <select class="form-select" wire:model="payment_type">
                                            <option value="">
                                                <?php echo e($lang->data['choose_payment_mode'] ?? 'Choose Payment Mode'); ?>

                                            </option>
                                            <option class="select-box" value="1">
                                                <?php echo e($lang->data['cash'] ?? 'Cash'); ?></option>
                                            <option class="select-box" value="2"><?php echo e($lang->data['upi'] ?? 'UPI'); ?>

                                            </option>
                                            <option class="select-box" value="3">
                                                <?php echo e($lang->data['card'] ?? 'Card'); ?></option>
                                            <option class="select-box" value="4">
                                                <?php echo e($lang->data['cheque'] ?? 'Cheque'); ?></option>
                                            <option class="select-box" value="5">
                                                <?php echo e($lang->data['bank_transfer'] ?? 'Bank Transfer'); ?></option>
                                        </select>
                                    </div>
                                    <?php $__errorArgs = ['paid_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php $__errorArgs = ['payment_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="error text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                                
                                <hr>
                                <div class="row align-items-center">
                                    <div class="col text-sm fw-600"><?php echo e($lang->data['balance'] ?? 'Balance'); ?>:</div>
                                    <div class="col-auto text-sm fw-600"><?php echo e(getCurrency()); ?>

                                        <?php echo e(number_format($balance, 2)); ?></div>
                                </div>
                                <hr>
                                <div class="col-12">
                                    <label
                                        class="form-label"><?php echo e($lang->data['notes_remarks'] ?? 'Notes / Remarks'); ?></label>
                                    <textarea class="form-control"
                                        placeholder="<?php echo e($lang->data['enter_notes'] ?? 'Enter Notes'); ?>"
                                        wire:model="payment_notes"></textarea>
                                </div>
                                <?php $__errorArgs = ['error'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="col-12 mt-2">
                                    <div class="alert alert-danger" role="alert">
                                        <strong class="text-white"> 
                                            <span class="mx-1">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-alert-triangle"><path d="M10.29 3.86L1.82 18a2 2 0 0 0 1.71 3h16.94a2 2 0 0 0 1.71-3L13.71 3.86a2 2 0 0 0-3.42 0z"/><line x1="12" y1="9" x2="12" y2="13"/><line x1="12" y1="17" x2="12.01" y2="17"/></svg>
                                            </span>
                                            <?php echo e($message); ?>

                                        </strong>
                                    </div>
                                    
                                </div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e($lang->data['cancel'] ?? 'Cancel'); ?></button>
                        <button type="submit" class="btn btn-primary"
                            wire:click.prevent="save"><?php echo e($lang->data['save_print'] ?? 'Save & Print'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script>
         "use strict";
        Livewire.on('printPage', orderId => {
            var $id = orderId;
            window.open(
                '<?php echo e(url('admin/orders/print-order/')); ?>' + '/' + $id,
                '_blank'
            );
            window.onfocus = function () { setTimeout(function () { window.location.reload(); }, 100); }
        })
    </script>
</div><?php /**PATH /home/charter2/demo.charteredadjusters.co.ke/resources/views/livewire/admin/orders/add-orders.blade.php ENDPATH**/ ?>