<div>
<div class="row" wire:poll>
    <div class="col-lg-12">
        <div class="row align-items-center">
            <div class="col-lg-3 col-md-6 col-12">
                <div class="card mb-4">
                    <div class="card-body p-3">
                        <div class="row align-items-center px-2">
                            <div class="col-8">
                                <div class="numbers py-2">
                                    <p class="text-sm mb-3 text-uppercase"><?php echo e($lang->data['pending_order'] ?? 'Pending Orders'); ?></p>
                                    <h5 class="font-weight-bolder">
                                        <?php echo e($pending_count); ?>

                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-secondary text-center rounded-circle">
                                    <i class="ni ni-basket text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-12">
                <div class="card mb-4">
                    <div class="card-body p-3">
                        <div class="row align-items-center px-2">
                            <div class="col-8">
                                <div class="numbers py-2">
                                    <p class="text-sm mb-3 text-uppercase"><?php echo e($lang->data['processing_order'] ?? 'Processing Order'); ?></p>
                                    <h5 class="font-weight-bolder">
                                        <?php echo e($processing_count); ?>

                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-warning text-center rounded-circle">
                                    <i class="ni ni-atom text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-12">
                <div class="card mb-4">
                    <div class="card-body p-3">
                        <div class="row align-items-center px-2">
                            <div class="col-8">
                                <div class="numbers py-2">
                                    <p class="text-sm mb-3 text-uppercase"><?php echo e($lang->data['ready_to_deliver'] ?? 'Ready To Deliver'); ?></p>
                                    <h5 class="font-weight-bolder">
                                        <?php echo e($ready_count); ?>

                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-success text-center rounded-circle">
                                    <i class="ni ni-like-2 text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 col-12">
                <div class="card mb-4">
                    <div class="card-body p-3">
                        <div class="row align-items-center px-2">
                            <div class="col-8">
                                <div class="numbers py-2">
                                    <p class="text-sm mb-3 text-uppercase"><?php echo e($lang->data['delivered_orders'] ?? 'Delivered Orders'); ?></p>
                                    <h5 class="font-weight-bolder">
                                        <?php echo e($delivered_count); ?>

                                    </h5>
                                </div>
                            </div>
                            <div class="col-4 text-end">
                                <div class="icon icon-shape bg-primary text-center rounded-circle">
                                    <i class="ni ni-check-bold text-lg opacity-10" aria-hidden="true"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header pb-4 pt-3">
                <div class="row g-2 align-items-center">
                    <div class="col-4">
                        <h5 class="pb-0 fw-500"><?php echo e($lang->data['todays_delivery'] ?? "Today's Delivery"); ?></h5>
                    </div>
                    <div class="col-5">
                        <input type="text" class="form-control" placeholder="<?php echo e($lang->data['search_here'] ?? 'Search Here...'); ?>" wire:model="search_query">
                    </div>
                    <div class="col-3">
                        <select class="form-select" wire:model="order_filter">
                            <option class="select-box" value=""><?php echo e($lang->data['all_orders'] ?? 'All Orders'); ?></option>
                            <option class="select-box" value="0"><?php echo e($lang->data['pending'] ?? 'Pending'); ?></option>
                            <option class="select-box" value="1"><?php echo e($lang->data['processing'] ?? 'Processing'); ?></option>
                            <option class="select-box" value="2"><?php echo e($lang->data['ready_to_deliver'] ?? 'Ready To Deliver'); ?></option>
                            <option class="select-box" value="3"><?php echo e($lang->data['delivered'] ?? 'Delivered'); ?></option>
                            <option class="select-box" value="4"><?php echo e($lang->data['returned'] ?? 'Returned'); ?></option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="card-body pt-0">
                <div class="row g-2 align-items-center">
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-12">
                        <div class="<?php echo e(getOrderStatusWithColor($item->status)); ?>">
                            <div class="d-flex justify-content-between mb-2">
                                <a href="<?php echo e(route('admin.view_single_order',$item->id)); ?>" type="button">
                                    <span class="fw-600 ms-2 text-dark text-xs mb-0"><?php echo e($item->customer_name?? $lang->data['walk_in_customer'] ?? 'Walk In Customer'); ?></span>
                                </a>
                                <a href="<?php echo e(route('admin.view_single_order',$item->id)); ?>" type="button">
                                    <span class="fw-600 text-dark text-xs me-2"><?php echo e($item->order_number); ?></span>
                                </a>
                            </div>
                            <?php
                                $services = \App\Models\OrderDetails::where('order_id',$item->id)->limit(4)->get();
                            ?>
                            <div class="pt-1 mb-0">
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $service = \App\Models\Service::where('id',$row->service_id)->first();
                                    ?>
                                <a class="avatar avatar-sm ms-2 p-1 bg-light">
                                    <img src="<?php echo e(asset('assets/img/service-icons/'.$service->icon)); ?>">
                                </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-4 mb-4" >
        <div class="card">
            <div class="card-header pb-0">
                <h5 class="pb-4 fw-500"><?php echo e($lang->data['overview'] ?? 'Overview'); ?></h5>
            </div>
            <div class="card-body pt-0 pb-2">
                <div class="row">
                    <div class="col-12 text-start mb-4" wire:ignore>
                        <div class="chart">
                            <canvas id="doughnut-chart" class="chart-canvas" height="300px"></canvas>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="d-flex justify-content-between">
                            <span class="badge badge-md badge-dot ms-4 text-start">
                                <i class="bg-secondary"></i>
                                <span class="text-dark text-xs"><?php echo e($lang->data['pending'] ?? 'Pending'); ?></span>
                            </span>
                            <span class="badge badge-md badge-dot me-4 text-start">
                                <i class="bg-warning"></i>
                                <span class="text-dark text-xs"><?php echo e($lang->data['processing'] ?? 'Processing'); ?></span>
                            </span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span class="badge badge-md badge-dot ms-4 text-start">
                                <i class="bg-success"></i>
                                <span class="text-dark text-xs"><?php echo e($lang->data['ready_to_deliver'] ?? 'Ready To Deliver'); ?></span>
                            </span>
                            <span class="badge badge-md badge-dot me-4 text-start">
                                <i class="bg-primary"></i>
                                <span class="text-dark text-xs"><?php echo e($lang->data['delivered'] ?? 'Delivered'); ?></span>
                            </span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span class="badge badge-md badge-dot ms-4 text-start">
                                <i class="bg-danger"></i>
                                <span class="text-dark text-xs"><?php echo e($lang->data['returned'] ?? 'Returned'); ?></span>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<input type="hidden" name="" id="chartdata" value="<?php echo e($array); ?>">
<?php $__env->startPush('js'); ?>
<script>
    "use strict";
    var ctx3 = document.getElementById("doughnut-chart").getContext("2d");
    var chartdata = document.getElementById("chartdata").value;
    new Chart(ctx3, {
        type: "doughnut",
        data: {
            datasets: [{
                label: "Projects",
                weight: 9,
                cutout: 60,
                tension: 0.9,
                pointRadius: 2,
                borderWidth: 2,
                backgroundColor: ['#8392ab', '#faae42', '#2dce89', '#0083ff', '#f5365c'],
                data: JSON.parse(chartdata),
                fill: false
            }],
            labels: ['Pending', 'Processing', 'Ready to Deliver', 'Delivered', 'Returned'],
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false,
                }
            },
            interaction: {
                intersect: true,
                mode: 'index',
            },
            scales: {
                y: {
                    grid: {
                        drawBorder: false,
                        display: false,
                        drawOnChartArea: false,
                        drawTicks: false,
                    },
                    ticks: {
                        display: false
                    }
                },
                x: {
                    grid: {
                        drawBorder: false,
                        display: false,
                        drawOnChartArea: false,
                        drawTicks: false,
                    },
                    ticks: {
                        display: false,
                    }
                },
            },
        },
    });
</script>
<?php $__env->stopPush(); ?>
</div><?php /**PATH /home/charter2/test.charteredadjusters.co.ke/resources/views/livewire/admin/dashboard.blade.php ENDPATH**/ ?>