<div>
    <div class="row align-items-center justify-content-between mb-4">
        <div class="col">
            <h5 class="fw-500 text-white"><?php echo e($lang->data['master_settings'] ?? 'Master Settings'); ?></h5>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body p-3">
                    <form class="row g-3 align-items-center">
                        <div><span
                                class="text-sm text-uppercase"><?php echo e($lang->data['application_details'] ?? 'Application Details'); ?></span>
                        </div>
                        <hr>
                        <div class="col-md-4">
                            <label
                                class="form-label"><?php echo e($lang->data['application_name'] ?? 'Application Name'); ?><span
                                    class="text-danger">*</span></label>
                            <input type="text" required autofocus class="form-control"
                                wire:model="default_application_name">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label"><?php echo e($lang->data['app_logo'] ?? 'App Logo'); ?></label>
                            <input type="file" class="form-control" wire:model="default_logo">
                        </div>
                        <div class="col-md-4">  
                            <label class="form-label"><?php echo e($lang->data['favicon'] ?? 'Favicon'); ?></label>
                            <input type="file" class="form-control" wire:model="default_favicon">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label"><?php echo e($lang->data['phone_number'] ?? 'Phone Number'); ?> <span
                                    class="text-danger">*</span></label>
                            <input type="number" required class="form-control"
                                placeholder="<?php echo e($lang->data['enter_phone_number'] ?? 'Enter Phone Number'); ?>"
                                wire:model="default_phone_number">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label"><?php echo e($lang->data['email'] ?? 'Email'); ?> <span
                                    class="text-danger">*</span></label>
                            <input type="email" required class="form-control"
                                placeholder="<?php echo e($lang->data['enter_email'] ?? 'Enter Email'); ?>" wire:model="email">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label"><?php echo e($lang->data['password'] ?? 'Password'); ?><span
                                    class="text-danger">*</span></label>
                            <input type="password" required class="form-control"
                                placeholder="<?php echo e($lang->data['password'] ?? 'Password'); ?>" wire:model="password">
                        </div>
                        <hr>
                        <div><span
                                class="text-sm text-uppercase"><?php echo e($lang->data['finance_settings'] ?? 'Finance Settings'); ?></span>
                        </div>
                        <hr>
                        <div class="col-md-3">
                            <label
                                class="form-label"><?php echo e($lang->data['currency_symbol'] ?? 'Currency Symbol'); ?></label>
                            <input type="text" class="form-control" placeholder="" wire:model="default_currency">
                        </div>
                        <div class="col-md-3">
                            <label
                                class="form-label"><?php echo e($lang->data['tax_percentage'] ?? 'Tax Percentage'); ?></label>
                            <input type="text" class="form-control" placeholder=""
                                wire:model="default_tax_percentage">
                        </div>
                        <div class="col-md-6">
                            <label for=""><?php echo e($lang->data['select_financial_year'] ?? 'Financial Year'); ?></label>
                            <?php
                                $inline_financial_year = App\Models\FinancialYear::latest()->get();
                            ?>
                            <select name="financial_year" class="form-select" wire:model="default_financial_year">
                                <option value=""><?php echo e($lang->data['select_financial_year'] ?? 'Select A Financial Year'); ?></option>
                                <?php $__currentLoopData = $inline_financial_year; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->year); ?> <?php if($row->starting_date): ?>
                                            [ <?php echo e(\Carbon\Carbon::parse($row->starting_date)->format('d/m/Y')); ?> to
                                            <?php echo e(\Carbon\Carbon::parse($row->ending_date)->format('d/m/Y')); ?> ]
                                        <?php endif; ?>
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <hr>
                        <div><span
                                class="text-sm text-uppercase"><?php echo e($lang->data['firm_address'] ?? 'Firm Address'); ?></span>
                        </div>
                        <hr>
                        <?php
                            $inline_countries = App\Models\Country::latest()->get();
                        ?>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e($lang->data['country'] ?? 'Country'); ?></label>
                            <select class="form-select" wire:model="default_country">
                                <?php $__currentLoopData = $inline_countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($row->country_code); ?>"><?php echo e($row->country_name); ?>

                                        [<?php echo e($row->country_code); ?>]</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e($lang->data['state'] ?? 'State'); ?></label>
                            <input type="text" class="form-control" placeholder="" wire:model="default_state">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e($lang->data['city'] ?? 'City'); ?></label>
                            <input type="text" class="form-control" placeholder="" wire:model="default_city">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e($lang->data['district'] ?? 'District'); ?></label>
                            <input type="text" class="form-control" placeholder="" wire:model="default_district">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e($lang->data['zip_code'] ?? 'Zip Code'); ?></label>
                            <input type="text" class="form-control" placeholder="" wire:model="default_zip_code">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e($lang->data['store_email'] ?? 'Store Email'); ?></label>
                            <input type="email" class="form-control" placeholder="" wire:model="store_email">
                        </div>
                        <div class="col-md-3">
                            <label
                                class="form-label"><?php echo e($lang->data['store_tax_number'] ?? 'Store Tax Number'); ?></label>
                            <input type="text" class="form-control" placeholder="" wire:model="store_tax">
                        </div>
                        <div class="col-12 mb-3">
                            <label for="inputAddress"
                                class="form-label"><?php echo e($lang->data['address'] ?? 'Address'); ?></label>
                            <textarea class="form-control" placeholder="" wire:model="default_address"></textarea>
                        </div>
                        <hr>
                        <div><span
                                class="text-sm text-uppercase"><?php echo e($lang->data['other_settings'] ?? 'Other Settings'); ?></span>
                        </div>
                        <hr>
                        <div class="col-md-3">
                            <label class="form-label"><?php echo e($lang->data['printer_pos'] ?? 'Printer POS'); ?></label>
                            <select class="form-select" wire:model="default_printer">
                                <option value="1">  <?php echo e($lang->data['a4'] ?? 'A4'); ?> </option>
                                <option value="2"> <?php echo e($lang->data['thermal'] ?? 'Thermal'); ?> </option>
                            </select>
                        </div>
                        <div class="d-flex align-items-center justify-content-end">
                            <div>
                                <button type="submit" class="btn btn-primary ms-4"
                                    wire:click.prevent="save()"><?php echo e($lang->data['save'] ?? 'Save'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/charter2/test.charteredadjusters.co.ke/resources/views/livewire/admin/settings/master-setting.blade.php ENDPATH**/ ?>