<div>
    <div class="row align-items-center justify-content-between mb-4">
        <div class="col">
            <h5 class="fw-500 text-white"><?php echo e($lang->data['expense'] ?? 'Expense'); ?></h5>
        </div>
        <div class="col-auto">
            <a data-bs-toggle="modal" data-bs-target="#addexpense" wire:click="resetInputFields"
                class="btn btn-icon btn-3 btn-white text-primary mb-0">
                <i class="fa fa-plus me-2"></i> <?php echo e($lang->data['add_new_expense'] ?? 'Add New Expense'); ?>

            </a>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="card-header p-4">
                    <div class="row">
                        <div class="col-md-12">
                            <input type="text" class="form-control"
                                placeholder="<?php echo e($lang->data['search_here'] ?? 'Search Here'); ?>" wire:model="search">
                        </div>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table align-items-center mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th class="text-uppercase text-secondary text-xs opacity-7">
                                        <?php echo e($lang->data['date'] ?? 'Date'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7 ps-2">
                                        <?php echo e($lang->data['amount'] ?? 'Amount'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs  opacity-7">
                                        <?php echo e($lang->data['towards'] ?? 'Towards'); ?></th>
                                    <th class="text-center text-uppercase text-secondary text-xs opacity-7">
                                        <?php echo e($lang->data['tax_included'] ?? 'Tax Included'); ?>?</th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7 ps-2">
                                        <?php echo e($lang->data['payment_mode'] ?? 'Payment Mode'); ?></th>
                                    <th class="text-uppercase text-secondary text-xs opacity-7 ps-2">
                                            <?php echo e($lang->data['created_by'] ?? 'Created By'); ?></th>
                                    <th class="text-secondary opacity-7"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <p class="text-sm px-3 mb-0">
                                                <?php echo e(date('d/m/Y', strtotime($row->expense_date))); ?>

                                            </p>
                                        </td>
                                        <td>
                                            <p class="text-sm font-weight-bold mb-0"><?php echo e($row->expense_amount); ?></p>
                                        </td>
                                        <td>
                                            <p class="text-sm px-3 mb-0">
                                                <?php echo e($row->expenseCategory->expense_category_name); ?></p>
                                        </td>
                                        <td class="align-middle text-center">
                                            <a type="button" class="badge badge-sm bg-dark text-uppercase">
                                                <?php if($row->tax_included): ?>
                                                    <?php echo e($lang->data['yes'] ?? 'YES'); ?>

                                                <?php else: ?>
                                                    <?php echo e($lang->data['no'] ?? 'No'); ?>

                                                <?php endif; ?>
                                            </a>
                                        </td>
                                        <td>
                                            <p class="text-sm mb-0 text-uppercase">
                                                <?php echo e(getpaymentMode($row->payment_mode)); ?></p>
                                        </td>
                                        <td>
                                            <p class="text-sm mb-0 text-uppercase">
                                                <?php echo e($row->user->name ?? ""); ?></p>
                                        </td>
                                        <td>
                                            <a data-bs-toggle="modal" data-bs-target="#editexpense"
                                                wire:click="edit(<?php echo e($row->id); ?>)" type="button"
                                                class="badge badge-xs badge-warning fw-600 text-xs">
                                                <?php echo e($lang->data['edit'] ?? 'Edit'); ?>

                                            </a>
                                            <a href="#" type="button" wire:click="delete(<?php echo e($row->id); ?>)"
                                                class="ms-2 badge badge-xs badge-danger text-xs fw-600">
                                                <?php echo e($lang->data['delete'] ?? 'Delete'); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" wire:ignore.self id="addexpense" tabindex="-1" role="dialog"
        aria-labelledby="addexpense" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title fw-600"><?php echo e($lang->data['add_expense'] ?? 'Add Expense'); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form>
                    <div class="modal-body">
                        <div class="row g-2 align-items-center">
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['date'] ?? 'Date'); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="date" required class="form-control" wire:model="expense_date">
                                <?php $__errorArgs = ['expense_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label
                                    class="form-label"><?php echo e($lang->data['expense_category'] ?? 'Expense Category'); ?><span
                                        class="text-danger">*</span></label>
                                <?php
                                    $inline_categories = App\Models\ExpenseCategory::latest()->get();
                                ?>
                                <select class="form-control" wire:model="expense_category_id">
                                    <option value="">
                                        <?php echo e($lang->data['choose_expense_category'] ?? 'Choose Expense Category'); ?>

                                    </option>
                                    <?php $__currentLoopData = $inline_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value=<?php echo e($row->id); ?>><?php echo e($row->expense_category_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['expense_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e('Expense Category Required'); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </select>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['expense_amount'] ?? 'Expense Amount'); ?>

                                    <span class="text-danger">*</span></label>
                                <input type="number" required class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_amount'] ?? 'Enter Amount'); ?>"
                                    wire:model="expense_amount">
                                <?php $__errorArgs = ['expense_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-2">
                                <label
                                    class="form-label"><?php echo e($lang->data['payment_mode'] ?? 'Payment Mode'); ?></label>
                                <select class="form-select" wire:model="payment_mode">
                                    <option value=""><?php echo e($lang->data['choose_payment_mode'] ?? 'Choose Payment Mode'); ?>

                                    </option>
                                    <option class="select-box" value="1"><?php echo e($lang->data['cash'] ?? 'Cash'); ?>

                                    </option>
                                    <option class="select-box" value="2"><?php echo e($lang->data['upi'] ?? 'UPI'); ?></option>
                                    <option class="select-box" value="3"><?php echo e($lang->data['card'] ?? 'Card'); ?>

                                    </option>
                                    <option class="select-box" value="4"><?php echo e($lang->data['cheque'] ?? 'Cheque'); ?>

                                    </option>
                                    <option class="select-box" value="5">
                                        <?php echo e($lang->data['bank_transfer'] ?? 'Bank Transfer'); ?></option>
                                </select>
                                <?php $__errorArgs = ['payment_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label"><?php echo e($lang->data['tax_included'] ?? 'Tax Included'); ?>

                                        ?</label>
                                    <div class="form-check ms-4">
                                        <input class="form-check-input" type="radio" id="no" name="tax"
                                            wire:model="tax_included" value="0">
                                        <label class="form-check-label"
                                            for="no"><?php echo e($lang->data['no'] ?? 'No'); ?></label>
                                    </div>
                                    <div class="form-check ms-2">
                                        <input class="form-check-input" type="radio" id="yes" name="tax"
                                            wire:model="tax_included" value="1">
                                        <label class="form-check-label"
                                            for="yes"><?php echo e($lang->data['yes'] ?? 'Yes'); ?></label>
                                    </div>
                                    <?php if($tax_included == 1): ?>
                                        <div class="ms-4">
                                            <input type="number" wire:model="tax_percentage" class="form-control"
                                                placeholder="<?php echo e($lang->data['tax_percentage'] ?? 'Tax Percentage'); ?>"
                                                style="width: 150px;">
                                            <?php $__errorArgs = ['tax_percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <label for="inputAddress"
                                    class="form-label"><?php echo e($lang->data['notes'] ?? 'Notes'); ?></label>
                                <textarea class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_notes'] ?? 'Enter Notes'); ?>"
                                    wire:model="note"></textarea>
                                <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal"><?php echo e($lang->data['cancel'] ?? 'Cancel'); ?></button>
                        <button type="submit" wire:click.prevent="store()"
                            class="btn btn-primary"><?php echo e($lang->data['save'] ?? 'Save'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade" wire:ignore.self id="editexpense" tabindex="-1" role="dialog"
        aria-labelledby="editexpense" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title fw-600"><?php echo e($lang->data['edit_expense'] ?? 'Edit Expense'); ?></h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form>
                    <div class="modal-body">
                        <div class="row g-2 align-items-center">
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['date'] ?? 'Date'); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="date" required class="form-control" wire:model="expense_date">
                                <?php $__errorArgs = ['expense_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label
                                    class="form-label"><?php echo e($lang->data['expense_category'] ?? 'Expense Category'); ?><span
                                        class="text-danger">*</span></label>
                                <?php
                                    $inline_categories = App\Models\ExpenseCategory::latest()->get();
                                ?>
                                <select class="form-control" wire:model="expense_category_id">
                                    <option value="">
                                        <?php echo e($lang->data['choose_expense_category'] ?? 'Choose Expense Category'); ?>

                                    </option>
                                    <?php $__currentLoopData = $inline_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value=<?php echo e($row->id); ?>><?php echo e($row->expense_category_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['expense_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e('Expense Category Required'); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </select>
                            </div>
                            <div class="col-md-12 mb-1">
                                <label class="form-label"><?php echo e($lang->data['expense_amount'] ?? 'Expense Amount'); ?>

                                    <span class="text-danger">*</span></label>
                                <input type="number" required class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_amount'] ?? 'Enter Amount'); ?>"
                                    wire:model="expense_amount">
                                <?php $__errorArgs = ['expense_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-2">
                                <label
                                    class="form-label"><?php echo e($lang->data['payment_mode'] ?? 'Payment Mode'); ?></label>
                                <select class="form-select" wire:model="payment_mode">
                                    <option value=""><?php echo e($lang->data['choose_payment_mode'] ?? 'Choose Payment Mode'); ?>

                                    </option>
                                    <option class="select-box" value="1"><?php echo e($lang->data['cash'] ?? 'Cash'); ?>

                                    </option>
                                    <option class="select-box" value="2"><?php echo e($lang->data['upi'] ?? 'UPI'); ?>

                                    </option>
                                    <option class="select-box" value="3"><?php echo e($lang->data['card'] ?? 'Card'); ?>

                                    </option>
                                    <option class="select-box" value="4"><?php echo e($lang->data['cheque'] ?? 'Cheque'); ?>

                                    </option>
                                    <option class="select-box" value="5">
                                        <?php echo e($lang->data['bank_transfer'] ?? 'Bank Transfer'); ?></option>
                                </select>
                                <?php $__errorArgs = ['payment_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-12 mb-1">
                                <div class="d-flex align-items-center justify-content-between">
                                    <label class="form-label"><?php echo e($lang->data['tax_included'] ?? 'Tax Included'); ?>

                                        ?</label>
                                    <div class="form-check ms-4">
                                        <input class="form-check-input" type="radio" id="no" name="tax"
                                            wire:model="tax_included" value="0">
                                        <label class="form-check-label"
                                            for="no"><?php echo e($lang->data['no'] ?? 'No'); ?></label>
                                    </div>
                                    <div class="form-check ms-2">
                                        <input class="form-check-input" type="radio" id="yes" name="tax"
                                            wire:model="tax_included" value="1">
                                        <label class="form-check-label"
                                            for="yes"><?php echo e($lang->data['yes'] ?? 'Yes'); ?></label>
                                    </div>
                                    <?php if($tax_included == 1): ?>
                                        <div class="ms-4">
                                            <input type="number" wire:model="tax_percentage" class="form-control"
                                                placeholder="<?php echo e($lang->data['tax_percentage'] ?? 'Tax Percentage'); ?>"
                                                style="width: 150px;">
                                            <?php $__errorArgs = ['tax_percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="error text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <label for="inputAddress"
                                    class="form-label"><?php echo e($lang->data['note'] ?? 'Note'); ?></label>
                                <textarea class="form-control"
                                    placeholder="<?php echo e($lang->data['enter_notes'] ?? 'Enter Notes'); ?>"
                                    wire:model="note"></textarea>
                                <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" wire:click.prevent="update()" class="btn btn-primary">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/charter2/test.charteredadjusters.co.ke/resources/views/livewire/admin/expense/expenses.blade.php ENDPATH**/ ?>